#include <inc/map.hpp>

Map::Map(void) {

  w = 16 * 12;
  h = 16 * 6;

  tile_w = 16;
  tile_h = 16;

  bitmap = NULL;
}

bool Map::loadBitmap(void) {

  bitmap = al_load_bitmap("png/map.png");

  return bitmap;
}

void Map::render(const float cam_x, const float cam_y) {

  al_hold_bitmap_drawing(true);

  for (unsigned int y = 0; y < h; ++y) {

    if (y * tile_h < cam_y - tile_h) {

      continue;
    }

    if (y * tile_h > cam_y + (tile_h * 6) + tile_h) {

      continue;
    }

    for (unsigned int x = 0; x < w; ++x) {

      if (x * tile_w < cam_x - tile_w) {

        continue;
      }

      if (x * tile_w > cam_x + (tile_w * 12)) {

        continue;
      }

      int sx = stoi(tiles[x][y].substr(0, 2)) * tile_w;
      int sy = stoi(tiles[x][y].substr(3, 5)) * tile_h;

      // Draw a layer of grass first.
      al_draw_bitmap_region(

        bitmap, 0, 0, tile_w, tile_h, x * tile_w - cam_x, y * tile_h - cam_y, 0
      );

      // Draw the target tile.
      al_draw_bitmap_region(

        bitmap, sx, sy, tile_w, tile_h, x * tile_w - cam_x, y * tile_h - cam_y, 0
      );
    }
  }

  al_hold_bitmap_drawing(false);
}

void Map::loadTiles(void) {

  tiles.resize(w);

  for (unsigned int y = 0; y < h; ++y) {

    for (unsigned int x = 0; x < w; ++x) {

      tiles[x].resize(h);

      // Cover the map with grass.
      tiles[x][y] = "00x00L";
    }
  }

  // Add map boundaries.
  for (unsigned int y = 0; y < h; ++y) {

    // Left corner.
    tiles[0][y] = "00x00S";

    // Right corner.
    tiles[w - 1][y] = "00x00S";

    for (unsigned int x = 0; x < w; ++x) {

      // Top corner.
      tiles[x][0] = "00x00S";

      // Bottom corner.
      tiles[x][h - 1] = "00x00S";
    }
  }

  // Generate mushrooms.
  generateTiles(45, "03x00S");

  // Generate autumn-colored trees.
  generateTiles(3, "02x00S");

  // Generate green trees.
  generateTiles(7, "01x00S");

  // Generate cat spawn markers.
  // Grass graphic is used here with a flag of "C" for "cat".
  generateTiles(99, "00x00C");
}

void Map::destroyBitmap(void) {

  al_destroy_bitmap(bitmap);
}

void Map::setRandomNumberGenerator(Random *R) {

  RandomNumberGenerator = R;
}

vector < vector < string > > &Map::getTiles(void) {

  return tiles;
}

void Map::generateTiles(const unsigned int probability, const string tile_data) {

  for (unsigned int y = 0; y < h; ++y) {

    for (unsigned int x = 0; x < w; ++x) {

      if (RandomNumberGenerator->getNumber() % probability == 1) {

        if (tiles[x][y] == "00x00L") {

          // Place the new tile on top of the grass tile.
          tiles[x][y] = tile_data;
        }
      }
    }
  }
}
